import { datatype, image, lorem } from 'faker';
import { getOverlaySrcAndSrcSet } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreLink } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../routing';
import { PlayerOverlay } from '../PlayerOverlay';
import { NextVideoOverlayBase, ScNextVideoPreview } from '.';

jest.mock('../../../../routing', () => ({
  ...jest.requireActual('../../../../routing'),
  renderTachyonLink: jest.fn(),
}));

describe(NextVideoOverlayBase, () => {
  beforeEach(() => {
    (renderTachyonLink as jest.Mock).mockReset();
  });

  const setup = createShallowWrapperFactory(NextVideoOverlayBase, () => ({
    dismissText: 'Dismiss',
    onTapOverlay: jest.fn(),
    video: {
      altText: lorem.words(),
      displayText: lorem.words(),
      id: datatype.uuid(),
      previewImageUrlTemplate: image.imageUrl(),
      title: lorem.sentence(),
    },
  }));

  it('does not allow tap through', () => {
    const { wrapper } = setup();
    expect(wrapper.find(PlayerOverlay).props().tapThrough).toBeUndefined();
  });

  it('links to VOD', () => {
    const videoId = datatype.uuid();
    const { wrapper } = setup({ video: { id: videoId } });

    expect(wrapper.find(CoreLink)).toHaveProp({
      linkTo: '/deferToRenderLink',
    });
    expect(renderTachyonLink).toHaveBeenCalledWith({
      interactionContent: 'next-video-overlay-link',
      interactionTargetPath: `/videos/${videoId}`,
      route: RouteName.Vod,
      routeParams: { videoID: videoId },
    });
  });

  it('renders a responsive image', () => {
    const imageUrlTemplate = lorem.word();
    const displayText = lorem.word();

    const { wrapper } = setup({
      video: { displayText, previewImageUrlTemplate: imageUrlTemplate },
    });

    expect(wrapper.find(ScNextVideoPreview)).toHaveProp(
      getOverlaySrcAndSrcSet(imageUrlTemplate),
    );
  });
});
