import { lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { FlexDirection, SVGAsset } from 'twitch-core-ui';
import { AssetLocation, PlayerControlsOverlayBase } from '.';

describe(PlayerControlsOverlayBase, () => {
  const setup = createShallowWrapperFactory(PlayerControlsOverlayBase, () => ({
    asset: SVGAsset.Muted,
    assetLocation: AssetLocation.Left,
    onTapOverlay: jest.fn(),
    text: lorem.word(),
  }));

  it('puts icon on the left of the text when instructed to do so', () => {
    const { wrapper } = setup({ assetLocation: AssetLocation.Left });

    expect(wrapper.find('ContrastLayout')).toHaveProp(
      'flexDirection',
      FlexDirection.RowReverse,
    );
    expect(wrapper.find('SVG').parent()).toHaveProp({
      padding: { right: 0.5 },
    });
  });

  it('puts icon on the right of the text when instructed to do so', () => {
    const { wrapper } = setup({ assetLocation: AssetLocation.Right });

    expect(wrapper.find('ContrastLayout')).toHaveProp({
      flexDirection: FlexDirection.Row,
    });
    expect(wrapper.find('SVG').parent()).toHaveProp({ padding: { left: 0.5 } });
  });
});
