import type { FC } from 'react';
import styled from 'styled-components';
import {
  AlignItems,
  Display,
  JustifyContent,
  Layout,
  Position,
} from 'twitch-core-ui';

export interface PlayerOverlayProps {
  onTapOverlay?: () => void;
  /**
   * Causes all pointer events (clicks/taps) to go "through" the overlay to
   * whatever is "visible" underneath it.
   */
  tapThrough?: true;
}

// istanbul ignore: wrapped Core UI is impossible to test
export const ScPlayerOverlay = styled(Layout)<{
  $tapThrough: boolean | undefined;
}>`
  ${({ $tapThrough }) => ($tapThrough ? 'pointer-events: none;' : '')};
`;

export const PlayerOverlay: FC<PlayerOverlayProps> = ({
  children,
  onTapOverlay,
  tapThrough,
}) => (
  <ScPlayerOverlay
    $tapThrough={tapThrough}
    alignItems={AlignItems.Center}
    display={Display.Flex}
    fullHeight
    fullWidth
    justifyContent={JustifyContent.Center}
    onClick={onTapOverlay}
    position={Position.Absolute}
  >
    {children}
  </ScPlayerOverlay>
);

PlayerOverlay.displayName = 'PlayerOverlay';
