import { createMountWrapperFactory } from 'tachyon-test-utils';
import { PlayerOverlay, ScPlayerOverlay } from '.';

describe(PlayerOverlay, () => {
  const setup = createMountWrapperFactory(PlayerOverlay);

  it('does not apply the tap through style when the prop is not set', () => {
    const { wrapper } = setup();
    expect(wrapper.find(ScPlayerOverlay)).toHaveProp({
      $tapThrough: undefined,
    });
  });

  it('applies the tap through style when the prop is set', () => {
    const { wrapper } = setup({ tapThrough: true });
    expect(wrapper.find(ScPlayerOverlay)).toHaveProp({
      $tapThrough: true,
    });
  });

  it('calls onTapOverlay handler when clicked', () => {
    const mockOnTapOverlay = jest.fn();
    const { wrapper } = setup({ onTapOverlay: mockOnTapOverlay });

    wrapper.find(ScPlayerOverlay).simulate('click');
    expect(mockOnTapOverlay).toHaveBeenCalled();
  });
});
