import type { FC } from 'react';
import { memo } from 'react';
import { Color, Layout, LoadingSpinner, SpinnerSize } from 'twitch-core-ui';
import { LOADING_SHOW_DELAY_MS } from '../../../../config';
import { PlayerOverlay } from '../PlayerOverlay';

// istanbul ignore next: trivial
const SpinnerOverlayBase: FC = () => (
  <PlayerOverlay tapThrough>
    <Layout color={Color.OverlayAlt} fullHeight fullWidth>
      <LoadingSpinner
        delay={LOADING_SHOW_DELAY_MS}
        fillContent
        inheritColor
        size={SpinnerSize.Large}
      />
    </Layout>
  </PlayerOverlay>
);

SpinnerOverlayBase.displayName = 'SpinnerOverlayBase';

export const SpinnerOverlay = memo(SpinnerOverlayBase);
