import type { FormatMessage } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import type { NextVideo } from '../../utils';
import type {
  OverlayFullScreenControls,
  OverlayNextVideo,
  OverlayPlayerControls,
} from '../OverlayManager';
import { PlayerOverlayType } from '../OverlayManager';
import { AssetLocation } from '../PlayerControlsOverlay';

export function tapToPlayOverlay(
  formatMessage: FormatMessage,
  onTapOverlay: () => void,
): OverlayFullScreenControls {
  return {
    asset: SVGAsset.Play,
    onTapOverlay,
    text: formatMessage('Tap to play', 'PlayerOverlay'),
    type: PlayerOverlayType.FullScreenPlayerControls,
  };
}

export function tapToUnmuteOverlay(
  formatMessage: FormatMessage,
  onTapOverlay: () => void,
): OverlayPlayerControls {
  return {
    asset: SVGAsset.Muted,
    assetLocation: AssetLocation.Left,
    onTapOverlay,
    text: formatMessage('Tap to unmute', 'PlayerOverlay'),
    type: PlayerOverlayType.PlayerControls,
  };
}

export function mutedSegmentsWarning(
  formatMessage: FormatMessage,
  onTapOverlay: () => void,
): OverlayPlayerControls {
  return {
    asset: SVGAsset.Close,
    assetLocation: AssetLocation.Right,
    onTapOverlay,
    text: formatMessage(
      'Audio for portions of this video has been muted as it appears to contain copyrighted content owned or controlled by a third party.',
      'PlayerOverlay',
    ),
    type: PlayerOverlayType.PlayerControls,
  };
}

type NextVideoOverlayArgs = {
  creatorName: string;
  formatMessage: FormatMessage;
  onTapOverlay: () => void;
  video: NextVideo;
};

export function nextVideoOverlay({
  creatorName,
  formatMessage,
  onTapOverlay,
  video,
}: NextVideoOverlayArgs): OverlayNextVideo {
  return {
    dismissText: formatMessage('Dismiss', 'PlayerOverlay'),
    onTapOverlay,
    type: PlayerOverlayType.NextVideo,
    video: {
      altText: formatMessage(
        'Image of the video that is recommended to be played next',
        'PlayerOverlay',
      ),
      displayText: formatMessage(
        'More from {creatorName}',
        { creatorName },
        'PlayerOverlay',
      ),
      id: video.id,
      previewImageUrlTemplate: video.previewThumbnailURL,
      title: video.title,
    },
  };
}
