import { datatype, image, lorem } from 'faker';
import { DefaultTwitchIntl } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import { PlayerOverlayType } from '../OverlayManager';
import { AssetLocation } from '../PlayerControlsOverlay';
import { nextVideoOverlay, tapToPlayOverlay, tapToUnmuteOverlay } from '.';

const formatMessage = DefaultTwitchIntl.formatMessage;

describe('OverlayPlayerControls', () => {
  describe(tapToUnmuteOverlay, () => {
    it('passes through click event and has mute related values', () => {
      const onTapOverlay = jest.fn();

      expect(tapToUnmuteOverlay(formatMessage, onTapOverlay)).toEqual({
        asset: SVGAsset.Muted,
        assetLocation: AssetLocation.Left,
        onTapOverlay,
        text: 'Tap to unmute',
        type: PlayerOverlayType.PlayerControls,
      });
    });
  });

  describe(tapToPlayOverlay, () => {
    it('passes through click event and icon', () => {
      const onTapOverlay = jest.fn();

      expect(tapToPlayOverlay(formatMessage, onTapOverlay)).toEqual({
        asset: SVGAsset.Play,
        onTapOverlay,
        text: 'Tap to play',
        type: PlayerOverlayType.FullScreenPlayerControls,
      });
    });
  });

  describe(nextVideoOverlay, () => {
    it('passes along parameters', () => {
      const creatorName = 'BigAndy';
      const previewThumbnailURL = image.imageUrl();
      const mockOnTapOverlay = jest.fn();
      const videoId = datatype.uuid();
      const title = lorem.sentence();

      const result = nextVideoOverlay({
        creatorName,
        formatMessage,
        onTapOverlay: mockOnTapOverlay,
        video: {
          id: videoId,
          previewThumbnailURL,
          title,
        },
      });

      expect(result).toEqual({
        dismissText: 'Dismiss',
        onTapOverlay: mockOnTapOverlay,
        type: PlayerOverlayType.NextVideo,
        video: {
          altText: 'Image of the video that is recommended to be played next',
          displayText: 'More from BigAndy',
          id: videoId,
          previewImageUrlTemplate: previewThumbnailURL,
          title,
        },
      });
    });
  });
});
