import { usePlaybackAutoplayStatus, usePlayerController } from 'pulsar';
import { useIntl } from 'tachyon-intl';
import { logger } from 'tachyon-logger';
import { exhaustedCase } from 'tachyon-utils';
import type { Overlay } from '../OverlayManager';
import { tapToPlayOverlay, tapToUnmuteOverlay } from '../overlayControls';
import { unknownRestrictionOverlay } from '../overlayMessages';

export function usePlayerOverlay(): Overlay | null {
  const playerController = usePlayerController();
  const blockedStatus = usePlaybackAutoplayStatus();
  const { formatMessage } = useIntl();

  if (!blockedStatus) {
    return null;
  }

  switch (blockedStatus) {
    case 'autoplay-blocked':
      return tapToPlayOverlay(formatMessage, () => {
        playerController?.setMuted(false);
        playerController?.play();
      });
    case 'unmuted-blocked':
      return tapToUnmuteOverlay(formatMessage, () => {
        playerController?.setMuted(false);
      });
    default:
      logger.error({
        category: 'usePlayerOverlay',
        // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
        message: `Unexpected blockedStatus '${blockedStatus}`,
        package: 'tomorrow',
      });
      return exhaustedCase(
        blockedStatus,
        unknownRestrictionOverlay(formatMessage),
      );
  }
}
