import { renderHook } from '@testing-library/react-hooks';
import { usePlaybackAutoplayStatus } from 'pulsar';
import { tapToPlayOverlay, tapToUnmuteOverlay } from '../overlayControls';
import { usePlayerOverlay } from '.';

jest.mock('pulsar', () => ({
  ...jest.requireActual('pulsar'),
  usePlaybackAutoplayStatus: jest.fn(),
}));
const mockUsePlaybackAutoplayStatus = usePlaybackAutoplayStatus as jest.Mock;

jest.mock('../overlayControls', () => ({
  tapToPlayOverlay: jest.fn(),
  tapToUnmuteOverlay: jest.fn(),
}));
const mockTapToPlayOverlay = tapToPlayOverlay as jest.Mock;
const mockTapToUnmuteOverlay = tapToUnmuteOverlay as jest.Mock;

describe('usePlayerOverlay', () => {
  it('returns tapToPlayOverlay when blockedStatus is autoplay-blocked', () => {
    mockUsePlaybackAutoplayStatus.mockReturnValueOnce('autoplay-blocked');
    renderHook(() => usePlayerOverlay());
    expect(mockTapToPlayOverlay).toHaveBeenCalled();
  });

  it('returns tapToUnmuteOverlay when blockedStatus is unmuted-blocked', () => {
    mockUsePlaybackAutoplayStatus.mockReturnValueOnce('unmuted-blocked');
    renderHook(() => usePlayerOverlay());
    expect(mockTapToUnmuteOverlay).toHaveBeenCalled();
  });
});
