export enum GQLRestriction {
  AllAccessPass = 'ALL_ACCESS_PASS',
  OrganizationAccessOnly = 'ORGANIZATION_ACCESS_ONLY',
  SubOnlyLive = 'SUB_ONLY_LIVE',
  Unknown = 'UNKNOWN',
}

export interface CommonPlayerDerivedPlaybackBlockers {
  /**
   * Note: Currently this and gqlUnknownRestriction share the same overlay but
   * should continue to be identified separately allowing the overlay processing
   * logic to differentiate the source. If our blocker logic is ever faulty and a
   * player renders on accident, this stops an unknown restriction from wiping
   * out a more contextual GQL blocker that might be available.
   */
  playerUnknownRestriction?: true;
}

export interface CommonGqlDerivedPlaybackBlockers {
  /**
   * Set when the content to play is not available in the user's region.
   */
  geoBlocked?: true;
  /**
   * Set when an unexpected restriction is returned from GQL.
   */
  gqlUnknownRestriction?: true;
  /**
   * Set when content requires maturity acknowledgment
   */
  mature?: true;
  /**
   * Set when the content is only available to subs
   */
  subOnly?: true;
}
