import { DefaultPosterImageDimensions, responsivePosterImageURL } from '.';

describe(responsivePosterImageURL, () => {
  it('replaces {width} and {height} placeholders for template Image URLs', () => {
    const testURL = 'https://therealderekt.com/image.{width}-{height}.png';
    expect(responsivePosterImageURL(testURL)).toEqual(
      `https://therealderekt.com/image.${DefaultPosterImageDimensions.Width}-${DefaultPosterImageDimensions.Height}.png`,
    );
  });

  it('replaces {width} for a template Image URL', () => {
    const testURL = 'https://therealderekt.com/image.{width}.png';
    expect(responsivePosterImageURL(testURL)).toEqual(
      `https://therealderekt.com/image.${DefaultPosterImageDimensions.Width}.png`,
    );
  });

  it('replaces {height} for a template Image URL', () => {
    const testURL = 'https://therealderekt.com/image.{height}.png';
    expect(responsivePosterImageURL(testURL)).toEqual(
      `https://therealderekt.com/image.${DefaultPosterImageDimensions.Height}.png`,
    );
  });

  it('does not mutate the provided URL if missing dimension placeholders', () => {
    const testURL = 'https://therealderekt.com/image.png';
    expect(responsivePosterImageURL(testURL)).toEqual(testURL);
  });
});
