import { datatype } from 'faker';
import type { VideoStatus } from '../../VodPlayer';
import { mockNextVideoEdges, mockNextVideoNode } from '../test-utils';
import { getNextVideo } from '.';

describe(getNextVideo, () => {
  it('returns first video by default', () => {
    const edges = mockNextVideoEdges();
    const result = getNextVideo({ omitVideoID: null, recentVideos: edges });
    const expectedNode = edges[0]!.node;

    expect(result).toEqual({
      id: expectedNode.id,
      previewThumbnailURL: expectedNode.previewThumbnailURL,
      title: expectedNode.title,
    });
  });

  it('returns the second video if the first one is the one that was just watched', () => {
    const edges = mockNextVideoEdges();

    const result = getNextVideo({
      omitVideoID: edges[0].node.id,
      recentVideos: edges,
    });

    const expectedNode = edges[1].node;
    expect(result).toEqual({
      id: expectedNode.id,
      previewThumbnailURL: expectedNode.previewThumbnailURL,
      title: expectedNode.title,
    });
  });

  it('returns the second video if the first one is still being recorded', () => {
    const edges = mockNextVideoEdges();
    (edges[0]!.node.status as VideoStatus) = 'RECORDING';

    const result = getNextVideo({
      omitVideoID: null,
      recentVideos: edges,
    });

    const expectedNode = edges[1].node;
    expect(result).toEqual({
      id: expectedNode.id,
      previewThumbnailURL: expectedNode.previewThumbnailURL,
      title: expectedNode.title,
    });
  });

  it('returns null if there is a single video that just played', () => {
    const watchedId = datatype.uuid();
    const edges = [{ node: mockNextVideoNode({ id: watchedId }) }];
    const result = getNextVideo({
      omitVideoID: watchedId,
      recentVideos: edges,
    });
    expect(result).toBeNull();
  });

  it('returns null if there are not any videos', () => {
    const result = getNextVideo({ omitVideoID: '123', recentVideos: [] });
    expect(result).toBeNull();
  });
});
