import { datatype, image, lorem } from 'faker';
import type { NextVideoNode } from '.';

export function mockNextVideoNode(
  overrides?: Partial<NextVideoNode>,
): NextVideoNode {
  return {
    id: datatype.uuid(),
    previewThumbnailURL: image.imageUrl(),
    status: 'RECORDED',
    title: lorem.sentence(),
    ...overrides,
  };
}

export function mockNextVideoEdges(): Array<{ node: NextVideoNode }> {
  return Array.from({ length: 3 }, () => ({ node: mockNextVideoNode() }));
}
