import {
  Platform,
  getOtherEnvMock,
  useStaticEnvironment,
} from 'tachyon-environment';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { isBrowser, useStorage } from 'tachyon-utils';
import { WOODSTOCK_PLATFORM } from '../../../../config';
import { useAddToHomeScreen } from '../AddToHomeScreenRoot';
import { AddToHomescreenPrompt } from '../Callouts';
import { AddToHomeScreenCTA, PAGEVIEW_THRESHOLD } from '.';

jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useStaticEnvironment: jest.fn(),
}));
const mockUseStaticEnvironment = useStaticEnvironment as jest.Mock;
mockUseStaticEnvironment.mockImplementation(() =>
  getOtherEnvMock({ platform: Platform.MobileWeb }),
);

jest.mock('tachyon-next-routing-utils', () => ({
  useRouterUtils: jest.fn(),
}));
const mockUseRouterUtils = useRouterUtils as jest.Mock;
mockUseRouterUtils.mockImplementation(() => ({
  pageCount: PAGEVIEW_THRESHOLD,
}));

jest.mock('tachyon-utils', () => ({
  ...jest.requireActual('tachyon-utils'),
  isBrowser: jest.fn(() => true),
  useStorage: jest.fn(() => [{ shouldShowCTA: true }, jest.fn()]),
}));
const mockIsBrowser = isBrowser as jest.Mock;
const mockUseStorage = useStorage as jest.Mock;

jest.mock('../AddToHomeScreenRoot', () => ({
  useAddToHomeScreen: jest.fn(() => ({
    canInstall: true,
  })),
}));
const mockUseAddToHomeScreen = useAddToHomeScreen as jest.Mock;

describe(AddToHomeScreenCTA, () => {
  const setup = createMountWrapperFactory(AddToHomeScreenCTA);

  describe('does not show when', () => {
    it('canInstall false', () => {
      mockUseAddToHomeScreen.mockImplementationOnce(() => ({
        canInstall: false,
      }));

      const { wrapper } = setup();

      expect(wrapper.find(AddToHomescreenPrompt).prop('show')).toEqual(false);
    });

    it('shouldShowCTA false', () => {
      mockUseStorage.mockImplementationOnce(() => [
        { shouldShowCTA: false },
        jest.fn(),
      ]);
      const { wrapper } = setup();

      expect(wrapper.find(AddToHomescreenPrompt).prop('show')).toEqual(false);
    });

    it('pageCount !== PAGEVIEW_THRESHOLD', () => {
      mockUseRouterUtils.mockImplementationOnce(() => ({ pageCount: 0 }));

      const { wrapper } = setup();

      expect(wrapper.find(AddToHomescreenPrompt).prop('show')).toEqual(false);
    });

    it('platform !== MobileWeb', () => {
      mockUseStaticEnvironment.mockImplementationOnce(() => ({
        common: { platform: WOODSTOCK_PLATFORM },
      }));

      const { wrapper } = setup();

      expect(wrapper.find(AddToHomescreenPrompt).prop('show')).toEqual(false);
    });
  });

  it('empty renders when server side', () => {
    mockIsBrowser
      .mockImplementationOnce(() => false)
      .mockImplementationOnce(() => false);
    const { wrapper } = setup();

    expect(wrapper).toBeEmptyRender();
  });
});
