import { useRouterUtils } from 'tachyon-next-routing-utils';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { RouteLinkPathnames, RouteName } from '../../../../routing';
import { AddToHomescreenPrompt, FullCTA, MinimalCTA } from '.';

jest.mock('tachyon-next-routing-utils', () => ({
  useRouterUtils: jest.fn(),
}));
const mockUseRouterUtils = useRouterUtils as jest.Mock;
mockUseRouterUtils.mockImplementation(() => ({
  currentPathname: RouteLinkPathnames[RouteName.Homepage],
}));

describe(AddToHomescreenPrompt, () => {
  beforeEach(() => {
    window.matchMedia = jest.fn(() => ({ matches: true })) as any;
  });

  afterEach(() => {
    // @ts-expect-error: tests
    delete window.matchMedia;
  });

  const setup = createShallowWrapperFactory(AddToHomescreenPrompt, () => ({
    onClose: jest.fn(),
    onInstall: jest.fn(),
    onOutsideClose: jest.fn(),
    show: true,
  }));

  it('shows the full CTA', () => {
    const { wrapper } = setup();

    expect(wrapper.find(FullCTA).prop('show')).toEqual(true);
    expect(wrapper.find(MinimalCTA).prop('show')).toEqual(false);
  });

  it('shows the minimal CTA on the channel page', () => {
    const mockRouterUtils = {
      currentPathname: RouteLinkPathnames[RouteName.Channel],
    };
    mockUseRouterUtils
      .mockImplementationOnce(() => mockRouterUtils)
      .mockImplementationOnce(() => mockRouterUtils);

    const { wrapper } = setup();

    expect(wrapper.find(FullCTA).prop('show')).toEqual(false);
    expect(wrapper.find(MinimalCTA).prop('show')).toEqual(true);
  });
});
