import type { FC } from 'react';
import type { ImpressionListenerProps } from 'tachyon-utils';
import { useEffectOnce, withImpressionListener } from 'tachyon-utils';
import type { CoreLinkProps } from 'twitch-core-ui';
import { CoreLink } from 'twitch-core-ui';

type CardLinkProps = CoreLinkProps &
  ImpressionListenerProps & {
    onImpression: () => void;
  };

// istanbul ignore next: trivial
export const CardLinkBase: FC<CardLinkProps> = ({
  impressionListener,
  onImpression: onDisplay,
  ...props
}) => {
  useEffectOnce(() => {
    impressionListener.registerImpressionCallback(onDisplay);
    return () => {
      impressionListener.unregisterImpressionCallback();
    };
  });

  return <CoreLink {...props} />;
};

CardLinkBase.displayName = 'CardLink';

export const CardLink = withImpressionListener(CardLinkBase);
