import type { FC } from 'react';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import {
  AlignItems,
  Background,
  BorderRadius,
  ChannelStatusTextIndicator,
  Display,
  JustifyContent,
  Layout,
  Position,
} from 'twitch-core-ui';

const ScIndicatorContainer = styled(Layout)`
  bottom: -0.5rem;
`;

// istanbul ignore next: trivial
export const LiveIndicator: FC = () => {
  const { formatMessage } = useIntl();

  return (
    <ScIndicatorContainer
      alignItems={AlignItems.Center}
      display={Display.Flex}
      fullWidth
      justifyContent={JustifyContent.Center}
      position={Position.Absolute}
    >
      <Layout
        background={Background.Base}
        borderRadius={BorderRadius.Large}
        display={Display.Inline}
      >
        <ChannelStatusTextIndicator
          label={formatMessage('LIVE', 'LiveIndicator')}
          mask={Background.Inherit}
        />
      </Layout>
    </ScIndicatorContainer>
  );
};

LiveIndicator.displayName = 'LiveIndicator';
