import type { FC } from 'react';
import { Avatar } from 'tachyon-more-ui';
import {
  AccentRegion,
  AvatarHalo,
  ChannelStatusIndicatorStatus,
  Layout,
  Position,
} from 'twitch-core-ui';
import { StaticTokenMap } from 'twitch-core-ui-tokens';
import { LiveIndicator } from './LiveIndicator';

type ChannelAvatarProps = {
  isLive: boolean;
  login: string;
  primaryColorHex: string | null;
  profileImageURL: string | null;
};

// <AvatarHalo /> converts pixel sizes to rems.
// Avatar is rendered as 8rem, meaning 80px.
// Extra 8px is for border and padding.
const AVATAR_HALO_SIZE = 88;

// istanbul ignore next: trivial
export const ChannelAvatar: FC<ChannelAvatarProps> = ({
  isLive,
  login,
  primaryColorHex,
  profileImageURL,
}) => {
  return (
    <Layout position={Position.Relative}>
      <AccentRegion
        inputColor={primaryColorHex ?? StaticTokenMap['color-accent']}
      >
        <AvatarHalo
          indicator={isLive && <LiveIndicator />}
          size={AVATAR_HALO_SIZE}
          status={
            isLive
              ? ChannelStatusIndicatorStatus.Live
              : ChannelStatusIndicatorStatus.Offline
          }
        >
          <Avatar alt="" sizeRem={8} src={profileImageURL} userLogin={login} />
        </AvatarHalo>
      </AccentRegion>
    </Layout>
  );
};

ChannelAvatar.displayName = 'ChannelAvatar';
