import type { FC } from 'react';
import styled from 'styled-components';
import type { SVGAsset } from 'twitch-core-ui';
import {
  AlignItems,
  Color,
  Display,
  FlexDirection,
  Icon,
  JustifyContent,
  Layout,
  Title,
  TitleSize,
} from 'twitch-core-ui';

type ChannelEmptyStateProps = {
  asset: SVGAsset;
  message?: string;
  title: string;
};

// istanbul ignore next: trivial
const ScIconWrapper = styled(Layout)`
  height: 9rem;
  width: 9rem;
`;

// istanbul ignore next: trivial
const ScWrapper = styled(Layout)`
  height: 40vmax;
  margin: 0 auto;
  max-width: 25rem;
  text-align: center;
  width: 80vw;
`;

// istanbul ignore next: trivial
export const ChannelEmptyState: FC<ChannelEmptyStateProps> = ({
  asset,
  message,
  title,
}) => {
  return (
    <ScWrapper
      alignItems={AlignItems.Center}
      color={Color.Alt2}
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      fullWidth
      justifyContent={JustifyContent.Center}
    >
      <ScIconWrapper color={Color.Base} padding={{ bottom: 2 }}>
        <Icon asset={asset} fillParent />
      </ScIconWrapper>
      <Layout padding={{ bottom: 2 }}>
        <Title size={TitleSize.Small}>{title}</Title>
      </Layout>
      {message && <Title size={TitleSize.ExtraSmall}>{message}</Title>}
    </ScWrapper>
  );
};

ChannelEmptyState.displayName = 'ChannelEmptyState';
