import type { FC } from 'react';
import type { MediaCardImageProps } from 'twitch-core-ui';
import {
  Color,
  CoreText,
  FontSize,
  MediaCard,
  MediaCardImage,
  MediaCardLink,
  MediaCardTitle,
  TextType,
} from 'twitch-core-ui';

type FeaturedCardCommonProps = {
  gameLabel: string;
  header: string;
  image: MediaCardImageProps['image'];
  title: string;
  topLeft: MediaCardImageProps['topLeft'];
};

// istanbul ignore next: trivial
export const FeaturedCardCommon: FC<FeaturedCardCommonProps> = ({
  gameLabel,
  header,
  image,
  title,
  topLeft,
}) => {
  return (
    <MediaCard
      image={<MediaCardImage image={image} topLeft={topLeft} />}
      meta={
        <>
          <FeaturedCardHeader>{header}</FeaturedCardHeader>
          <MediaCardTitle>{title}</MediaCardTitle>
          <MediaCardLink>{gameLabel}</MediaCardLink>
        </>
      }
    />
  );
};

FeaturedCardCommon.displayName = 'FeaturedCardCommon';

// istanbul ignore next: trivial
const FeaturedCardHeader: FC = ({ children }) => {
  return (
    <CoreText color={Color.Link} fontSize={FontSize.Size6} type={TextType.H4}>
      {children}
    </CoreText>
  );
};

FeaturedCardHeader.displayName = 'FeaturedCardHeader';
