import { buildTestMessageEvent, createTestEvents } from 'tachyon-chat';
import { ChatMessage } from 'tachyon-chat-ui';
import { getiOSEnvMock } from 'tachyon-environment';
import { DefaultTwitchIntl } from 'tachyon-intl';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { ChatPaneBase } from '.';

describe(ChatPaneBase, () => {
  const testEventList = createTestEvents();

  const setup = createMountWrapperFactory(ChatPaneBase, () => ({
    channelDisplayName: 'TestName',
    chatMessages: [],
    intl: DefaultTwitchIntl,
    pause: () => undefined,
    reportLatencyEvent: () => () => undefined,
    staticEnv: getiOSEnvMock(),
    unpause: () => undefined,
  }));

  describe('when there are no messages', () => {
    it('renders the basic component without messages or more messages button', () => {
      const { wrapper } = setup();
      expect(wrapper.find(Button)).not.toExist();
      expect(wrapper.find(ChatMessage)).not.toExist();
    });

    it('sets user scroll to true', () => {
      const { wrapper } = setup();
      expect((wrapper.instance() as ChatPaneBase).userScroll).toEqual(true);
    });
  });

  describe('when there are messages', () => {
    it('sets autoscroll state to true', () => {
      const { wrapper } = setup({ chatMessages: testEventList });
      expect(wrapper.state('autoscroll')).toEqual(true);
    });

    it('renders the component with messages', () => {
      const { wrapper } = setup({ chatMessages: testEventList });

      expect(wrapper.find(ChatMessage)).toHaveLength(testEventList.length);
    });
  });

  it('shows more messages button on state change', () => {
    const { wrapper } = setup({
      chatMessages: [buildTestMessageEvent()],
    });
    expect(wrapper.state('autoscroll')).toEqual(true);
    expect(wrapper.find(Button)).not.toExist();

    wrapper.setState({ autoscroll: false });
    expect(wrapper.find(Button).text()).toEqual('More messages below');
  });

  it.todo('shows more messages in response to scroll event');
  it.todo('hides more messages appropriately');
  it.todo('goes through automated scrollToBottom functionality');
});
