import type { FC } from 'react';
import {
  Color,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
  Overflow,
  TextType,
  WhiteSpace,
} from 'twitch-core-ui';
import { ContentInfoBoxContainer } from '../ContentInfoBoxContainer';
import { InfoBoxAvatar } from '../InfoBoxAvatar';

export type ContentInfoBoxProps = {
  contentMeta: {
    description: string | null;
    header: string | null;
  };
  owner: {
    displayName: string;
    login: string;
    profileImageURL: string | null;
  } | null;
};

/**
 * Info box that supports partial degredation of content info.
 */
export const ContentInfoBox: FC<ContentInfoBoxProps> = ({
  children,
  contentMeta: { description, header },
  owner,
}) => (
  <ContentInfoBoxContainer>
    {owner && <InfoBoxAvatar owner={owner} />}
    <Layout
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      overflow={Overflow.Hidden}
      padding={{ right: 1 }}
    >
      {header && (
        <CoreText
          color={Color.Base}
          ellipsis
          fontSize={FontSize.Size3}
          whiteSpace={WhiteSpace.NoWrap}
        >
          {header}
        </CoreText>
      )}
      {description && (
        <Layout overflow={Overflow.Auto}>
          <CoreText
            color={Color.Alt}
            fontSize={FontSize.Size5}
            type={TextType.P}
            whiteSpace={WhiteSpace.NoWrap}
          >
            {description}
          </CoreText>
        </Layout>
      )}
      {children}
    </Layout>
  </ContentInfoBoxContainer>
);

ContentInfoBox.displayName = 'ContentInfoBox';
