import Faker from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { InfoBoxAvatar } from '../InfoBoxAvatar';
import { ContentInfoBox } from '.';

describe(ContentInfoBox, () => {
  const setup = createShallowWrapperFactory(ContentInfoBox, () => ({
    contentMeta: {
      description: Faker.lorem.sentence(),
      header: Faker.lorem.sentence(),
    },
    owner: {
      displayName: Faker.internet.userName(),
      login: Faker.internet.userName(),
      profileImageURL: Faker.image.imageUrl(),
    },
  }));

  it('shows Avatar when owner is defined', () => {
    const { wrapper } = setup();
    expect(wrapper.find(InfoBoxAvatar)).toExist();
  });

  it('hides Avatar when owner is not defined', () => {
    const { wrapper } = setup({ owner: undefined });
    expect(wrapper.find(InfoBoxAvatar)).not.toExist();
  });

  it('hides the header when null', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(CoreText)).toHaveLength(2);

    wrapper.setProps({
      contentMeta: {
        ...props.contentMeta,
        header: null,
      },
    });
    expect(wrapper.find(CoreText)).toHaveLength(1);
  });

  it('hides the description when null', () => {
    const { props, wrapper } = setup();
    expect(wrapper.find(CoreText)).toHaveLength(2);

    wrapper.setProps({
      contentMeta: {
        ...props.contentMeta,
        description: null,
      },
    });
    expect(wrapper.find(CoreText)).toHaveLength(1);
  });
});
