import { act } from 'react-dom/test-utils';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { useAddToHomeScreenCTA } from '..';
import { UpsellSheet } from '../UpsellSheet';
import { FollowButtonUpsell } from '.';

const mockTestLink = 'https://test.branch.url';

jest.mock('../../../utils', () => ({
  useDeepLink: () => mockTestLink,
}));

jest.mock('../AddToHomeScreen', () => ({
  useAddToHomeScreenCTA: jest.fn(() => ({ enableShowCTA: jest.fn() })),
}));
const mockUseAddToHomeScreenStorage = useAddToHomeScreenCTA as jest.Mock;

describe(FollowButtonUpsell, () => {
  const setup = createMountWrapperFactory(FollowButtonUpsell, () => ({
    displayName: 'TestName',
  }));

  it('starts out closed', () => {
    const { wrapper } = setup();
    expect(wrapper.find(UpsellSheet)).not.toExist();
  });

  it('opens the upsell sheet on click', () => {
    const { wrapper } = setup();
    expect(wrapper.find(UpsellSheet)).not.toExist();

    act(() => {
      wrapper.find(Button).props().onClick!({
        stopPropagation: jest.fn,
      } as any);
    });

    wrapper.update();

    expect(wrapper.find(UpsellSheet)).toExist();
  });

  it('reenables PWA CTA engagement on click', () => {
    const enableShowCTA = jest.fn();
    mockUseAddToHomeScreenStorage.mockImplementationOnce(() => ({
      enableShowCTA,
    }));
    const { wrapper } = setup();

    act(() => {
      wrapper.find(Button).props().onClick!({
        stopPropagation: jest.fn(),
      } as any);
    });

    wrapper.update();

    expect(enableShowCTA).toHaveBeenCalledTimes(1);
  });
});
