import { datatype } from 'faker';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { InfiniteList } from '.';

describe(InfiniteList, () => {
  const setup = createMountWrapperFactory(InfiniteList, () => ({
    itemRenderer: () => <div id="item" key={datatype.uuid()} />,
    length: 1000,
    loadMore: () => null,
    pageSize: 100,
  }));

  it('shows the first page of data inside expected class', () => {
    const pageSize = datatype.number(500) + 1;

    const { wrapper } = setup({ pageSize });

    expect(wrapper.find('div#item')).toHaveLength(pageSize);
  });

  it('asks to load more data when the user gets to the end of the list', () => {
    const pageSize = datatype.number(10) + 1;
    const loadMore = jest.fn();

    setup({ length: pageSize, loadMore, pageSize });

    expect(loadMore).toHaveBeenCalledTimes(1);
  });

  it('does not load more if the user is at the start of the list ', () => {
    const pageSize = datatype.number(10) + 1;
    const loadMore = jest.fn();

    setup({ length: 1000, loadMore, pageSize });

    expect(loadMore).not.toHaveBeenCalled();
  });

  it('loads more items if the user only has two pages of content left', () => {
    const pageSize = 10;
    const loadMore = jest.fn();

    const { wrapper } = setup({ length: 30, loadMore, pageSize });
    expect(loadMore).not.toHaveBeenCalled();

    wrapper.setProps({ length: 29 });
    expect(loadMore).toHaveBeenCalledTimes(1);
  });
});
