import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { getFormattedUserDisplayName } from 'tachyon-utils';
import { Avatar, CoreLink } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../routing';

export type InfoBoxAvatarProps = {
  owner: {
    displayName: string;
    login: string;
    profileImageURL: string | null;
  };
  /**
   * Prevents the Avatar from being a link to support Woodstock.
   */
  withoutLink?: true;
};

export const InfoBoxAvatar: FC<InfoBoxAvatarProps> = ({
  owner,
  withoutLink,
}) => {
  const { formatMessage } = useIntl();
  const channelDisplayName = getFormattedUserDisplayName(owner);

  const avatarImage = (
    <Avatar
      alt=""
      size={50}
      src={owner.profileImageURL}
      userLogin={owner.login}
    />
  );

  const label = formatMessage(
    "Go to {channel}'s profile",
    { channel: channelDisplayName },
    'InfoBoxAvatar',
  );

  return withoutLink ? (
    avatarImage
  ) : (
    <CoreLink
      aria-label={label}
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        interactionContent: 'avatar',
        route: RouteName.ChannelHome,
        routeParams: { login: owner.login },
      })}
    >
      {avatarImage}
    </CoreLink>
  );
};

InfoBoxAvatar.displayName = 'InfoBoxAvatar';
