import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Avatar, CoreLink } from 'twitch-core-ui';
import { InfoBoxAvatar } from '.';

describe(InfoBoxAvatar, () => {
  const setup = createShallowWrapperFactory(InfoBoxAvatar, () => ({
    latencyName: '',
    owner: {
      displayName: 'TheRealDerekt',
      login: 'therealderekt',
      profileImageURL: null,
    },
  }));

  it('renders with a link by default', () => {
    const { wrapper } = setup();
    expect(wrapper.find(CoreLink)).toExist();
    expect(wrapper.find(Avatar)).toExist();
  });

  it('renders a the avatar without a link', () => {
    const { wrapper } = setup({ withoutLink: true });
    expect(wrapper.find(CoreLink)).not.toExist();
    expect(wrapper.find(Avatar)).toExist();
  });
});
