import faker from 'faker';
import { act } from 'react-dom/test-utils';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import type { OfflineChannelUpsell_user } from './__generated__/OfflineChannelUpsell_user.graphql';
import { OfflineChannelUpsellBase } from '.';

jest.mock('tachyon-logger', () => ({ logger: { error: jest.fn() } }));

jest.mock('tachyon-environment', () => {
  const original = jest.requireActual('tachyon-environment');
  return {
    ...original,
    useStaticEnvironment: original.mockUseStaticEnvironment(),
  };
});

const mockBranchUrl = 'https://test.branch.url';
jest.mock('react-branch', () => ({
  ...jest.requireActual('react-branch'),
  useLink: () => [mockBranchUrl],
}));

describe('OfflineChannelUpsell', () => {
  const mockUser: OfflineChannelUpsell_user = {
    ' $refType': null as never,
    displayName: faker.lorem.word(),
    largeProfileImageURL: faker.random.image(),
    login: faker.lorem.word(),
  };

  describe(OfflineChannelUpsellBase, () => {
    const setup = createMountWrapperFactory(OfflineChannelUpsellBase, () => ({
      user: mockUser,
    }));

    it('renders as expected', async () => {
      const { wrapper } = setup();

      await act(async () => {
        wrapper.update();
        // resolve the Promise in useEffect
        await Promise.resolve();
      });
      // allow the state update to occur
      wrapper.update();

      expect(wrapper.html()).not.toBeNull();
      expect(wrapper.find(Button)).toExist();
      expect(wrapper.find(Button).last().text()).toBe('Not now');
    });

    it('can be dismissed,', async () => {
      const { wrapper } = setup();

      await act(async () => {
        wrapper.update();
        // resolve the Promise in useEffect
        await Promise.resolve();
      });
      // allow the state update to occur
      wrapper.update();

      expect(wrapper.html()).not.toBeNull();

      const dismissButton = wrapper.find(Button).last();
      act(() => {
        dismissButton.props().onClick!({} as any);
      });
      wrapper.update();
      expect(wrapper.html()).toBeNull();
    });
  });
});
