import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import type { ButtonProps } from 'twitch-core-ui';
import { Button } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../routing';
import { useDeepLink } from '../../../utils';

export const INTERACTION_CONTENT_OPEN_IN_APP = 'open_in_app';
export const BRANCH_CAMPAIGN = 'mobile_web_campaign';

export type OpenInAppOwnProps = ButtonProps & {
  /**
   * Contextual identifier for the branch campaign.
   */
  callToActionIdentifier: string;
  /**
   * Overrides "currentRouteName" as defined by the application router that
   * would otherwise be set as the location to open in app.
   */
  targetAppLocation?: string;
};

export const OpenInApp: FC<OpenInAppOwnProps> = ({
  callToActionIdentifier,
  children,
  targetAppLocation,
  ...props
}) => {
  const { formatMessage } = useIntl();
  const href = useDeepLink(
    BRANCH_CAMPAIGN,
    callToActionIdentifier,
    targetAppLocation,
  );

  if (!href) {
    return null;
  }

  return (
    <Button
      {...props}
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({
        interactionContent: INTERACTION_CONTENT_OPEN_IN_APP,
        route: RouteName.External,
        routeParams: { href },
      })}
    >
      {children ?? formatMessage('Open in App', 'OpenInApp')}
    </Button>
  );
};
OpenInApp.displayName = 'OpenInApp';
