import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { renderTachyonLink } from '../../../routing';
import { OpenInApp } from '.';

const mockTestLink = 'https://test.branch.url';

jest.mock('../../../utils', () => ({
  useDeepLink: () => mockTestLink,
}));

jest.mock('../../../routing', () => ({
  ...jest.requireActual('../../../routing'),
  renderTachyonLink: jest.fn(),
}));

describe(OpenInApp, () => {
  const setup = createShallowWrapperFactory(OpenInApp, () => ({
    callToActionIdentifier: 'test',
  }));

  beforeEach(() => {
    (renderTachyonLink as jest.Mock).mockReset();
  });

  it('renders a Button', () => {
    const { wrapper } = setup();

    expect(wrapper.find(Button)).toExist();
  });
});
