import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { exhaustedCase } from 'tachyon-utils';
import {
  ChannelStatusTextIndicator,
  ChannelStatusTextIndicatorType,
} from 'twitch-core-ui';
import type { TwitchIntl } from 'twitch-intl';

export type StreamStatusType = 'hosting' | 'live';

type StreamStatusIndicatorProps = {
  isOverlay?: boolean;
  type: StreamStatusType;
};

const getLabel = ({ formatMessage }: TwitchIntl, type: StreamStatusType) => {
  switch (type) {
    case 'live':
      return formatMessage('Live', 'StreamStatusIndicator');
    case 'hosting':
      return formatMessage('Hosting', 'StreamStatusIndicator');
    default:
      exhaustedCase(type, null);
  }
};

const getComponentType = (type: StreamStatusType) => {
  switch (type) {
    case 'live':
      return ChannelStatusTextIndicatorType.Live;
    case 'hosting':
      return ChannelStatusTextIndicatorType.Hosting;
    default:
      exhaustedCase(type, null);
  }
};

export const StreamStatusIndicator: FC<StreamStatusIndicatorProps> = ({
  isOverlay,
  type,
}) => {
  const intl = useIntl();
  const label = getLabel(intl, type);
  const componentType = getComponentType(type);

  if (!(label && componentType)) {
    return null;
  }

  return (
    <ChannelStatusTextIndicator
      label={label}
      overlay={isOverlay}
      type={getComponentType(type)}
    />
  );
};

StreamStatusIndicator.displayName = 'StreamTypeIndicator';
