import { createShallowWrapperFactory } from 'tachyon-test-utils';
import {
  ChannelStatusTextIndicator,
  ChannelStatusTextIndicatorType,
} from 'twitch-core-ui';
import { StreamStatusIndicator } from '.';

describe(StreamStatusIndicator, () => {
  const setup = createShallowWrapperFactory(StreamStatusIndicator, () => ({
    type: 'hosting',
  }));

  it('renders when hosting', () => {
    const { wrapper } = setup({ type: 'hosting' });
    expect(wrapper.find(ChannelStatusTextIndicator).prop('label')).toBe(
      'Hosting',
    );
    expect(wrapper.find(ChannelStatusTextIndicator).prop('type')).toBe(
      ChannelStatusTextIndicatorType.Hosting,
    );
  });

  it('renders when live', () => {
    const { wrapper } = setup({ type: 'live' });
    expect(wrapper.find(ChannelStatusTextIndicator).prop('label')).toBe('Live');
    expect(wrapper.find(ChannelStatusTextIndicator).prop('type')).toBe(
      ChannelStatusTextIndicatorType.Live,
    );
  });

  it('renders null when unknown', () => {
    const { wrapper } = setup({ type: null } as any);
    expect(wrapper).toBeEmptyRender();
  });
});
