import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Toast } from 'twitch-core-ui';
import { TimedToast } from '.';

describe(TimedToast, () => {
  const setup = createShallowWrapperFactory(TimedToast, () => ({
    children: 'hello',
    onClickClose: jest.fn(),
    secondsVisible: 10000,
  }));

  const setupNoLifecycle = createShallowWrapperFactory(
    TimedToast,
    () => ({
      children: 'hello',
      onClickClose: jest.fn(),
      secondsVisible: 10000,
    }),
    {
      disableLifecycleMethods: true,
    },
  );

  it('renders nothing until marked ready', () => {
    expect(setupNoLifecycle().wrapper).toBeEmptyRender();
  });

  it('has an animated toast with children inside when enabled is true', () => {
    const { props, wrapper } = setupNoLifecycle();
    wrapper.setState({ readyForFirstRender: true });
    expect(wrapper.contains(props.children as string)).toEqual(true);
  });

  it('has an animated toast with children inside when enabled is false', () => {
    const { props, wrapper } = setupNoLifecycle();
    wrapper.setState({ enabled: false, readyForFirstRender: true });
    expect(wrapper.contains(props.children as string)).toEqual(true);
  });

  describe('state enabled becomes false', () => {
    it('when close is called', () => {
      const { props, wrapper } = setupNoLifecycle();
      wrapper.setState({ enabled: true, readyForFirstRender: true });
      wrapper.find(Toast).simulate('close');

      expect(wrapper).toHaveState({ enabled: false });
      expect(props.onClickClose).toHaveBeenCalledTimes(1);
    });

    it('when the hide timer expires', () => {
      const { wrapper } = setup();

      wrapper.setState({ enabled: true, readyForFirstRender: true });
      jest.runAllTimers();

      expect(wrapper).toHaveState({
        enabled: false,
        readyForFirstRender: true,
      });
    });
  });
});
