import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { useJSEnabled } from 'tachyon-utils';
import { ButtonIcon, ButtonIconSize, CoreLink, SVGAsset } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../routing';

// istanbul ignore next: trivial
export const SearchButton: FC = () => {
  const { formatMessage } = useIntl();
  const enabled = useJSEnabled();
  return (
    <CoreLink
      linkTo="/deferToRenderLink"
      renderLink={renderTachyonLink({ route: RouteName.Search })}
    >
      <ButtonIcon
        aria-label={formatMessage('Search', 'SearchInput')}
        disabled={!enabled}
        icon={SVGAsset.NavSearch}
        size={ButtonIconSize.Large}
      />
    </CoreLink>
  );
};

SearchButton.displayName = 'SearchButton';
