import { InteractionType, useInteractionTracking } from 'tachyon-event-tracker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Interactable } from 'twitch-core-ui';
import { MenuItem, MenuItemType } from '.';

jest.mock('tachyon-event-tracker', () => ({
  ...jest.requireActual('tachyon-event-tracker'),
  useInteractionTracking: jest.fn(),
}));
const mockUseInteractionTracking = useInteractionTracking as jest.Mock;
const trackEvent = jest.fn();
mockUseInteractionTracking.mockImplementation(() => trackEvent);

describe(MenuItem, () => {
  const setup = createShallowWrapperFactory(MenuItem, () => ({
    interactionContent: 'menu_item_mock',
    text: 'mock-button',
    type: MenuItemType.Link,
  }));

  describe('onClick', () => {
    it('trackEvent is invoked', () => {
      const { wrapper } = setup();
      wrapper.find(Interactable).simulate('click');
      expect(trackEvent).toHaveBeenCalledWith({
        interaction: InteractionType.Click,
        interactionContent: 'menu_item_mock',
      });
    });

    it('trackEvent not invoked when url present', () => {
      const { wrapper } = setup({
        url: 'mock-url',
      });
      wrapper.find(Interactable).simulate('click');
      expect(trackEvent).not.toHaveBeenCalled();
    });

    it('original onClick is invoked', () => {
      const onClick = jest.fn();

      const { wrapper } = setup({
        onClick,
      });
      wrapper.find(Interactable).simulate('click');

      expect(onClick).toHaveBeenCalled();
    });
  });
});
