import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { OpenInApp } from '..';
import { showOpenInApp } from '../../../utils';
import { TopNav } from '.';

jest.mock('../../../utils', () => ({
  showOpenInApp: jest.fn(() => true),
}));
const showOpenInAppMock = showOpenInApp as jest.Mock;

describe(TopNav, () => {
  const setup = createShallowWrapperFactory(TopNav);

  describe('<OpenInApp />', () => {
    it('shows by default', () => {
      const { wrapper } = setup();

      expect(wrapper.find(OpenInApp)).toExist();
    });

    it('hides when showOpenInApp is false', () => {
      showOpenInAppMock.mockImplementationOnce(() => false);
      const { wrapper } = setup();

      expect(wrapper.find(OpenInApp)).not.toExist();
    });
  });
});
