import { act } from 'react-dom/test-utils';
import { MockRouterUtilsProvider } from 'tachyon-next-routing-utils';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import {
  RouteName,
  pathnameFromRouteName,
  renderTachyonLink,
} from '../../../routing';
import type { UpsellSheetProps } from '.';
import { UpsellSheet } from '.';

const mockTestLink = 'https://test.branch.url';
jest.mock('../../../utils', () => ({
  useDeepLink: () => mockTestLink,
}));

jest.mock('../../../routing', () => ({
  ...jest.requireActual('../../../routing'),
  renderTachyonLink: jest.fn(),
}));

jest.mock('tachyon-environment', () => {
  const original = jest.requireActual('tachyon-environment');
  return {
    ...original,
    useStaticEnvironment: original.mockUseStaticEnvironment(),
  };
});

describe(UpsellSheet, () => {
  beforeEach(() => {
    (renderTachyonLink as jest.Mock).mockReset();
  });

  const testUrl = 'https://test.branch.url';

  const WrappedTestComponent = (props: UpsellSheetProps) => (
    <MockRouterUtilsProvider
      value={{
        currentAsPath: '/ninja',
        currentPathname: pathnameFromRouteName(RouteName.Channel),
        currentQuery: {},
      }}
    >
      <UpsellSheet {...props} />
    </MockRouterUtilsProvider>
  );

  const setup = createMountWrapperFactory(WrappedTestComponent, () => ({
    branchCampaign: 'test_branch_campaign',
    buttonText: 'Test Button',
    onClose: () => null,
    title: 'Test Title',
  }));

  it('renders', async () => {
    const { wrapper } = setup();

    await act(async () => {
      wrapper.update();
      // resolve the Promise in useEffect
      await Promise.resolve();
    });
    // allow the state update to occur
    wrapper.update();

    expect(wrapper.find(Button)).toHaveProp({
      linkTo: '/deferToRenderLink',
    });
    expect(renderTachyonLink).toHaveBeenCalledWith({
      interactionContent: 'upsell_cta',
      route: RouteName.External,
      routeParams: { href: testUrl },
    });
  });
});
