import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { useIntl } from 'tachyon-intl';
import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
  TagAction,
} from 'twitch-core-ui';
import type { TagLinkPublicProps } from '../TagLink';
import { TagLink } from '../TagLink';
import type { ActiveTagFilter_query } from './__generated__/ActiveTagFilter_query.graphql';

export interface ActiveTagFilterProps
  extends Pick<TagLinkPublicProps, 'gameAlias' | 'page'> {
  query: ActiveTagFilter_query;
}

export const ActiveTagFilterBase: FC<ActiveTagFilterProps> = ({
  gameAlias,
  page,
  query: { contentTag: tag },
}) => {
  const { formatMessage } = useIntl();

  if (!tag) {
    return null;
  }

  return (
    <Layout
      alignItems={AlignItems.Center}
      display={Display.Flex}
      flexDirection={FlexDirection.Row}
    >
      <Layout padding={{ right: 2 }}>
        <CoreText bold color={Color.Base} fontSize={FontSize.Size5}>
          {formatMessage('Filtered by:', 'FilteredByTag')}
        </CoreText>
      </Layout>
      <TagLink
        action={TagAction.Remove}
        gameAlias={gameAlias}
        page={page}
        position={0}
        tag={tag}
      />
    </Layout>
  );
};

ActiveTagFilterBase.displayName = 'ActiveTagFilterBase';

export const ActiveTagFilter = createFragmentContainer(ActiveTagFilterBase, {
  query: graphql`
    fragment ActiveTagFilter_query on Query {
      contentTag(id: $tagId) {
        ...TagLink_tag
      }
    }
  `,
});
