import { TagPage } from 'tachyon-discovery';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { TagLink } from '../TagLink';
import { ActiveTagFilterBase } from '.';

describe(ActiveTagFilterBase, () => {
  const setup = createShallowWrapperFactory(ActiveTagFilterBase, () => ({
    page: TagPage.Browse,
    query: {
      ' $refType': 'ActiveTagFilter_query',
      contentTag: {
        ' $fragmentRefs': { TagLink_tag: true },
      },
    },
  }));

  it('should not render without a tag', () => {
    const { wrapper } = setup({ query: { contentTag: null } });
    expect(wrapper.find(TagLink)).not.toExist();
  });

  it('renders a TagLink', () => {
    const { wrapper } = setup();
    expect(wrapper.find(TagLink)).toExist();
  });
});
