import Faker from 'faker';
import { TagEvent, TagPage, TagSection } from 'tachyon-discovery';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Tag, TagAction } from 'twitch-core-ui';
import { TagLinkBase } from '.';

const mockOnCustomEvent = jest.fn();

jest.mock('tachyon-event-tracker', () => ({
  useCustomTracking: () => mockOnCustomEvent,
}));

describe(TagLinkBase, () => {
  const setup = createShallowWrapperFactory(TagLinkBase, () => ({
    action: TagAction.Remove,
    gameAlias: Faker.lorem.words(2),
    page: TagPage.Browse,
    position: 0,
    tag: {
      ' $refType': 'TagLink_tag',
      id: Faker.datatype.uuid(),
      localizedDescription: Faker.lorem.words(5),
      localizedName: Faker.lorem.words(1),
      tagName: Faker.lorem.words(1),
    },
  }));

  beforeEach(() => {
    jest.resetAllMocks();
  });

  it('renders a tag', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Tag)).toExist();
  });

  it('reports event after clicking on Tag', () => {
    const { wrapper } = setup({
      action: undefined,
      page: TagPage.Stream,
    });
    expect(mockOnCustomEvent).not.toHaveBeenCalled();

    wrapper.find(Tag).simulate('click');
    expect(mockOnCustomEvent).toHaveBeenCalledWith(
      expect.objectContaining({
        dismiss: false,
        event: TagEvent.Filter,
        section: TagSection.LiveChannels,
      }),
    );
  });

  it('reports event after removing a Tag', () => {
    const { wrapper } = setup();
    expect(mockOnCustomEvent).not.toHaveBeenCalled();
    expect(wrapper.find(Tag)).toExist();

    wrapper.find(Tag).simulate('click');
    expect(mockOnCustomEvent).toHaveBeenCalledWith(
      expect.objectContaining({
        dismiss: true,
        event: TagEvent.Filter,
        section: TagSection.Browse,
      }),
    );
  });
});
