import Faker from 'faker';
import { TagPage } from 'tachyon-discovery';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { TagLink } from '../TagLink';
import { TagListBase } from '.';

describe(TagListBase, () => {
  const setup = createShallowWrapperFactory(TagListBase, () => ({
    gameAlias: Faker.lorem.words(5),
    page: TagPage.Browse,
    video: {
      ' $refType': 'TagList_video',
      videoTags: [
        {
          ' $fragmentRefs': { TagLink_tag: true },
        },
      ],
    },
  }));

  it('renders a list of video tags', () => {
    const { wrapper } = setup();
    expect(wrapper.find(TagLink)).toExist();
  });
});
