import type { TachyonPageContext } from 'tachyon-next-types';
import { flattenHeaderOrParam } from 'tachyon-utils';
import { TAG_QUERY_PARAM_KEY } from '../../../../config';

export type TagQueryPathParameters = Record<typeof TAG_QUERY_PARAM_KEY, string>;

export interface TagQueryVariables {
  hasTagId: boolean;
  tagId: string;
  tags?: Array<string> | null;
}

export function getTagQueryVariables({
  query,
}: TachyonPageContext<TagQueryPathParameters>): TagQueryVariables {
  const tags = flattenHeaderOrParam(query[TAG_QUERY_PARAM_KEY]) ?? '';
  // If the user is getting redirected from the web with comma separated Tags,
  // only the first tag will be taken. The rest will be ignored
  const [firstTag] = tags.split(',');

  return {
    hasTagId: !!firstTag,
    tagId: firstTag,
    tags: firstTag ? [firstTag] : null,
  };
}
