import { TAG_QUERY_PARAM_KEY } from '../../../../config';
import { getTagQueryVariables } from '.';

describe(getTagQueryVariables, () => {
  it('parses only the first tag of a tag CSV to queryVariables', () => {
    expect(
      getTagQueryVariables({
        query: {
          [TAG_QUERY_PARAM_KEY]: 'tag1,tag2',
        },
      } as any),
    ).toEqual({
      hasTagId: true,
      tagId: 'tag1',
      tags: ['tag1'],
    });
  });

  it('parses a non-CSV tag value to queryVariables', () => {
    expect(
      getTagQueryVariables({
        query: {
          [TAG_QUERY_PARAM_KEY]: 'tag1',
        },
      } as any),
    ).toEqual({
      hasTagId: true,
      tagId: 'tag1',
      tags: ['tag1'],
    });
  });

  it('handles queryVariables when no tags query is present', () => {
    expect(
      getTagQueryVariables({
        query: {},
      } as any),
    ).toEqual({
      hasTagId: false,
      tagId: '',
      tags: null,
    });
  });
});
