import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Button, ButtonIcon, SVGAsset } from 'twitch-core-ui';
import { WebShareButton } from '.';

describe(WebShareButton, () => {
  beforeAll(() => {
    navigator.share = jest.fn();
  });
  afterAll(() => {
    (navigator as any).share = undefined;
  });
  const setup = createShallowWrapperFactory(WebShareButton);

  it('renders a button by default', () => {
    const { wrapper } = setup();
    expect(wrapper.find(Button)).toExist();
    expect(wrapper.find(Button)).toHaveProp({
      icon: SVGAsset.Share,
      onClick: expect.any(Function),
    });
  });

  it('renders a button icon when passed the iconOnly prop', () => {
    const { wrapper } = setup({ iconOnly: true });
    expect(wrapper.find(ButtonIcon)).toExist();
    expect(wrapper.find(ButtonIcon)).toHaveProp({
      icon: SVGAsset.Share,
      onClick: expect.any(Function),
    });
  });
});
