import type { FC } from 'react';
import { createContext, useMemo } from 'react';
import { BASE_CANONICAL_URL, DEFAULT_TITLE } from '../../../../config';

type WebShareContext = {
  canonicalURI: string;
  titleText: string;
};

export const webShareContext = createContext<WebShareContext>({
  canonicalURI: BASE_CANONICAL_URL,
  titleText: DEFAULT_TITLE,
});

export const WebShareRoot: FC<Partial<WebShareContext>> = ({
  children,
  canonicalURI = BASE_CANONICAL_URL,
  titleText = DEFAULT_TITLE,
}) => {
  // https://developer.mozilla.org/en-US/docs/Web/API/Navigator/share#parameters
  const shareContextData = useMemo(
    () => ({
      canonicalURI,
      titleText,
    }),
    [canonicalURI, titleText],
  );

  return (
    <webShareContext.Provider value={shareContextData}>
      {children}
    </webShareContext.Provider>
  );
};

WebShareRoot.displayName = 'WebShareRoot';
