import { canShare, wrapUrlWithTracking } from './utils';

describe(canShare, () => {
  it('returns true if navigator.share exists', () => {
    navigator.share = jest.fn();
    expect(canShare()).toBe(true);
  });

  it('returns false if navigator.share does not exist', () => {
    (navigator as any).share = undefined;
    expect(canShare()).toBe(false);
  });
});

const BASE_CASE_URL =
  'https://twitch.tv/qa_vod_automation?tt_medium=mobile_web_share&tt_content=share_button';
const TT_CONTENT_URL =
  'https://twitch.tv/qa_vod_automation?tt_medium=mobile_web_share&tt_content=test_case';
const EXISTING_QUERY_PARAMS_URL =
  'https://twitch.tv/qa_vod_automation?foo=bar&tt_medium=mobile_web_share&tt_content=share_button';
const TT_CONTENT_AND_QUERY_PARAMS_URL =
  'https://twitch.tv/qa_vod_automation?foo=bar&tt_medium=mobile_web_share&tt_content=test_case';

describe(wrapUrlWithTracking, () => {
  const BASE_URL = 'https://twitch.tv/qa_vod_automation';
  const TT_CONTENT = 'test_case';

  it('handles the base case', () => {
    expect(wrapUrlWithTracking(BASE_URL)).toEqual(BASE_CASE_URL);
  });

  it('handles existing query params', () => {
    expect(wrapUrlWithTracking(`${BASE_URL}?foo=bar`)).toEqual(
      EXISTING_QUERY_PARAMS_URL,
    );
  });

  it('accepts tt_content as a second parameter', () => {
    expect(wrapUrlWithTracking(BASE_URL, TT_CONTENT)).toEqual(TT_CONTENT_URL);
  });

  it('accepts tt_content as a second parameter with existing query params', () => {
    expect(wrapUrlWithTracking(`${BASE_URL}?foo=bar`, TT_CONTENT)).toEqual(
      TT_CONTENT_AND_QUERY_PARAMS_URL,
    );
  });
});
