import { isBrowser } from 'tachyon-utils';

export function canShare(): boolean {
  return isBrowser() && typeof navigator.share === 'function';
}

const TT_CONTENT = 'share_button';
const TT_MEDIUM = 'mobile_web_share';

export function wrapUrlWithTracking(
  url: string,
  tt_content: string = TT_CONTENT,
): string {
  return `${url}${url.includes('?') ? '&' : '?'}tt_medium=${TT_MEDIUM}${
    tt_content && `&tt_content=${tt_content}`
  }`;
}
