import type { FC } from 'react';
import { useCallback } from 'react';
import styled from 'styled-components';
import { ExtendInteractionMedium } from 'tachyon-event-tracker';
import { CHANNELS_PAGE_SIZE } from '../../../config';
import { InfiniteList } from '../../common';
import { DirectoryStreamCard } from '../DirectoryStreamCard';

export interface StreamReference {
  readonly ' $fragmentRefs': { DirectoryStreamCard_stream: true };
  id: string;
}

interface ChannelListProps {
  hideTags?: boolean;
  loadMore: () => void;
  streams: StreamReference[];
}

const ScChannelList = styled(InfiniteList)`
  display: flex;
  flex-flow: wrap row;
  padding: 0.5%;
  width: 100%;

  @media (max-width: 540px) and (orientation: portrait) {
    padding: 1%;
  }
`;

export const ChannelList: FC<ChannelListProps> = ({
  hideTags,
  loadMore,
  streams,
}) => {
  const itemRenderer = useCallback(
    (idx: number): JSX.Element => (
      <DirectoryStreamCard
        hideTags={hideTags}
        key={streams[idx].id}
        position={idx}
        stream={streams[idx]}
      />
    ),
    [streams, hideTags],
  );

  return (
    <ExtendInteractionMedium value="channel_list">
      <ScChannelList
        itemRenderer={itemRenderer}
        length={streams.length}
        loadMore={loadMore}
        pageSize={CHANNELS_PAGE_SIZE}
      />
    </ExtendInteractionMedium>
  );
};

ChannelList.displayName = 'ChannelList';
