import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import styled from 'styled-components';
import { useTrackedListItem } from 'tachyon-event-tracker';
import type { GameCardCommonProps } from '../GameCardCommon';
import { GameCardCommon } from '../GameCardCommon';
import type { DirectoryGameCard_game } from './__generated__/DirectoryGameCard_game.graphql';

const BOX_ART_SIZES = [
  {
    mediaCondition: '(max-width: 540px) and (orientation: portrait)',
    size: '50vw',
  },
  { size: '25vw' },
];

const ScDirectoryStreamCardWrapper = styled.div`
  padding: 0.5%;
  width: 25%;

  @media (max-width: 540px) and (orientation: portrait) {
    padding: 1%;
    width: 50%;
  }
`;

export interface DirectoryGameCardProps
  extends Omit<
    GameCardCommonProps,
    'game' | 'interactionContent' | 'srcSetSizes'
  > {
  game: DirectoryGameCard_game;
  position: number;
}

export const DirectoryGameCardBase: FC<DirectoryGameCardProps> = ({
  position,
  ...props
}) => {
  const { interactionContent } = useTrackedListItem(position);
  return (
    <ScDirectoryStreamCardWrapper>
      <GameCardCommon
        {...props}
        interactionContent={interactionContent}
        srcSetSizes={BOX_ART_SIZES}
      />
    </ScDirectoryStreamCardWrapper>
  );
};

DirectoryGameCardBase.displayName = 'DirectoryGameCardBase';

export const DirectoryGameCard = createFragmentContainer(
  DirectoryGameCardBase,
  {
    game: graphql`
      fragment DirectoryGameCard_game on Game {
        ...GameCardCommon_game
      }
    `,
  },
);
