import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import styled from 'styled-components';
import { useTrackedListItem } from 'tachyon-event-tracker';
import type { StreamCardCommonPublicProps } from '../StreamCardCommon';
import { StreamCardCommon } from '../StreamCardCommon';
import type { DirectoryStreamCard_stream } from './__generated__/DirectoryStreamCard_stream.graphql';

const CHANNEL_THUMBNAIL_SIZES = [
  {
    mediaCondition: '(max-width: 540px) and (orientation: portrait)',
    size: '100vw',
  },
  {
    mediaCondition: '(min-width: 768px) and (orientation: landscape)',
    size: '33.3333vw',
  },
  { size: '50vw' },
];

const ScDirectoryStreamCardWrapper = styled.div`
  padding: 0.5%;
  width: 50%;

  @media (max-width: 540px) and (orientation: portrait) {
    padding: 1%;
    width: 100%;
  }

  @media (min-width: 768px) and (orientation: landscape) {
    width: 33.3333%;
  }
`;

interface DirectoryStreamCardProps
  extends Omit<
    StreamCardCommonPublicProps,
    'interactionContent' | 'srcSetSizes'
  > {
  position: number;
  stream: DirectoryStreamCard_stream;
}

export const DirectoryStreamCardBase: FC<DirectoryStreamCardProps> = ({
  position,
  ...props
}) => {
  const { interactionContent } = useTrackedListItem(position);

  const { stream } = props;
  if (!stream.broadcaster?.login) {
    return null;
  }

  return (
    <ScDirectoryStreamCardWrapper>
      <StreamCardCommon
        {...props}
        interactionContent={interactionContent}
        srcSetSizes={CHANNEL_THUMBNAIL_SIZES}
      />
    </ScDirectoryStreamCardWrapper>
  );
};

DirectoryStreamCardBase.displayName = 'DirectoryStreamCardBase';

export const DirectoryStreamCard = createFragmentContainer(
  DirectoryStreamCardBase,
  {
    stream: graphql`
      fragment DirectoryStreamCard_stream on Stream {
        ...StreamCardCommon_stream
        broadcaster {
          login
        }
      }
    `,
  },
);
